/*****************************************************************************
*  LPC81x RC5 decoder program for MicroCore48 rev B board
*
*  1. Use SCT timer to send encoded RC5 frames.
*  2. Use USART to print received RC5 frames to PC terminal
*****************************************************************************/
#include "LPC8xx.h"
#include "global.h"

void MRT_IRQHandler(void)
{
    LPC_MRT->Channel[0].STAT = 1;                          // acknowledge MRT irq
}

void MRT_Init(void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL  |= (1 << 10);               // enable MRT clock

    LPC_MRT->Channel[0].INTVAL  = (SystemCoreClock / 8);   // 1/8 sec timeout
    LPC_MRT->Channel[0].INTVAL |= (1U << 31);
    LPC_MRT->Channel[0].CTRL    = (1 << 0) | (0 << 1);     // enable + repeated mode
    NVIC_EnableIRQ(MRT_IRQn);                              // enable Multi-Rate timer irq
}

int main (void) 
{
  static uint8_t  trg = 1;
  static uint8_t  tgl = 1;
  static uint16_t frame;

    LPC_SWM->PINASSIGN5 = 0x0EFFFFFF;                      // SCT INP_0 at P0_14
    LPC_SWM->PINASSIGN6 = 0x07FFFFFF;                      // STC OUTP_0 at P0_7

    RC5_Init();
    MRT_Init();

    while (1)
    {
        frame = (1   << 13) |                              // set start (S) bit
                (1   << 12) |                              // set field (F) bit
                (tgl << 11) |                              // clr control / toggle (C) bit
                (20  << 6 ) |                              // system  = 20
                (9   << 0 );                               // command = 9

        if (!(LPC_GPIO_PORT->PIN0 & (1 << 1)))             // P0.1 high to low?
        {
            if (trg)
            {
                trg = 0;                                   // trigger P0.1 low
            }
            RC5_Send(frame);
        }
        else if ((LPC_GPIO_PORT->PIN0 & (1 << 1)) && !trg) // P0.1 low to high?
        {
            trg = 1;                                       // trigger P0.1 high
            tgl = !tgl;                                    // toggle  P0.1 high
        }

        __wfi();                                           // goto sleep
    }
}
